-- Delete from UpdatePackages
DELETE FROM [Monitor].[UpdatePackages]
WHERE CAST(PARSENAME([UpdatePackages].ToVersion, 4) AS INT) > 7 OR 
	  (CAST(PARSENAME([UpdatePackages].ToVersion, 4) AS INT) = 7 AND CAST(PARSENAME([UpdatePackages].ToVersion, 3) AS INT) > 41);

-- Delete from FeatureTableFragments
DELETE FROM [ConfigurationSchema].[FeatureTableFragments]
WHERE FragmentName = 'MonitorFeatures';

-- Update ServiceGroupDetails
UPDATE [Monitor].[ServiceGroupDetails]
SET [Value] = (SELECT TOP 1
				   [FromVersion]
			   FROM 
				   [Monitor].[UpdatePackages]
			   ORDER BY 
				   CAST(PARSENAME([ToVersion], 4) AS INT) DESC,
				   CAST(PARSENAME([ToVersion], 3) AS INT) DESC,
				   CAST(PARSENAME([ToVersion], 2) AS INT) DESC,
				   CAST(PARSENAME([ToVersion], 1) AS INT) DESC)
WHERE
	[Property] = 'ServiceGroup.DBSchemaVersion';

-- Check if CloudSiteConfiguration table exists before dropping it
IF OBJECT_ID('[Monitor].[CloudSiteConfiguration]', 'U') IS NOT NULL
BEGIN
	DROP TABLE [Monitor].[CloudSiteConfiguration];
END